﻿//////////////////////////////////////////////
// DefaultTestObserver.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkDebug
{
	class OutputFormatter ;
	class OutputTarget ;

	struct TestNameFilters ;
}

/// Includes ---------------------------------

// nkDebug
#include "../../Dll/DllDefines.h"

#include "TestObserver.h"

// nkLog
#include <NilkinsMemory/Containers/String.h>

/// Class ------------------------------------

namespace nkDebug
{
	class DLL_NKDEBUG_EXPORT DefaultTestObserver final : public TestObserver
	{
		public  :

			// Functions
			// Constructor, destructor
			DefaultTestObserver () noexcept ;
			virtual ~DefaultTestObserver () ;

			// Setters
			void setLiveFormatter (OutputFormatter* formatter) ;
			void setFinalFormatter (OutputFormatter* formatter) ;
			void setLiveOutput (OutputTarget* target) ;
			void setFinalOutput (OutputTarget* target) ;

			// Hooks
			virtual void onRunLaunch (const TestRunParameters& params) override ;
			virtual void onRunEnd () override ;
			virtual void onClassLaunch (const TestClassObserverInformation& info) override ;
			virtual void onClassBypass (const TestClassObserverInformation& info) override ;
			virtual void onClassEnd (const TestClassObserverInformation& info) override ;
			virtual void onTestLaunch (const TestFunctionObserverInformation& info) override ;
			virtual void onTestBypass (const TestFunctionObserverInformation& info) override ;
			virtual void onTestSuccess (const TestFunctionObserverInformation& info) override ;
			virtual void onTestFailure (const TestFunctionObserverInformation& info) override ;

		private :

			// Attributes
			// Formatter
			OutputFormatter* _liveFormatter ;
			OutputFormatter* _finalFormatter ;

			// Output
			OutputTarget* _liveOutput ;
			OutputTarget* _finalOutput ;

			// Cache
			nkMemory::String _cachedString ;
	} ;
}